
% clear
% TimeStart = datevec(now);
% eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_InitialCondiction']);

% copyfile('Sim_IC_All.m',['', DATESTR(datenum(TimeStart),30), '_Sim_IC_All.m']);

Second = 1/86400; % This express one second in terms of a day (one day has 24*60*60 = 86400 seconds)

DateStart1 = datenum(2009,12,14,23,02,09);
DateEnd1 =   datenum(2009,12,14,23,28,22);
DateStart2 = datenum(2009,12,15,06,38,45);
DateEnd2 =   datenum(2009,12,15,09,01,02);
DateStart3 = datenum(2009,12,16,17,16,20);
DateEnd3 =   datenum(2009,12,16,17,17,00);
DateStart4 = datenum(2009,12,17,17,22,05);
DateEnd4 =   datenum(2009,12,22,04,10,15);
DateStart5 = datenum(2010,01,16,16,49,00);
DateEnd5 =   datenum(2010,01,16,17,27,15);
DateStart6 = datenum(2010,01,16,20,24,00);
DateEnd6 =   datenum(2010,01,16,20,37,15);


TimeStartEnd = [DateStart1:Second:DateEnd1 DateStart2:Second:DateEnd2 DateStart3:Second:DateEnd3 DateStart4:Second:DateEnd4 DateStart5:Second:DateEnd5 DateStart6:Second:DateEnd6]; % DateStart2:Second:DateEnd2 DateStart3:Second:DateEnd3 DateStart4:Second:DateEnd4 DateStart5:Second:DateEnd5 DateStart6:Second:DateEnd6];
NumberSimulationsTotal = size(TimeStartEnd,2);
NumberSimulationsLeft = NumberSimulationsTotal; % Before starting the simulation, the NumberSimulationsLeft is equal to the  NumberSimulationsTotal

PercentageProgress = 2;

for i = TimeStartEnd; % We scan the Hard Disk for the Inition Condition file by means of its Data/Hour prefix
    
    c = datevec(i);
    DataHora = datestr(c,30);
    fid1 = fopen([DataHora, '_InitionConditionNotProblems.mat']); % If FOPEN returns -1, it means that the apporpriete file does not exist on the Hard Disk. In all the other cases it exist.
    fid2 = fopen([DataHora, '_InitionConditionProblems.mat']); % If FOPEN returns -1, it means that the apporpriete file does not exist on the Hard Disk. In all the other cases it exist.
    
    if fid1 ~= -1  % If FOPEN returns -1, it means that the apporpriete file does not exist on the Hard Disk. In all the other cases it exist.
		load([DataHora, '_InitionConditionNotProblems.mat']);
		eval(['cd ', DATESTR(datenum(TimeStart),30), '_InitialCondiction']);
        save([DataHora, '_InitionConditionNotProblems.mat'], ['InitionConditionNotProblems_', DataHora]);
		cd ..
        if eval(['size(InitionConditionNotProblems_', DataHora, ',1)']) > 1
            if length(who('InitionConditionNotProblems')) == 0 % If the Initial Condition variable was not created before on the workspace, we create it.
                eval(['InitionConditionNotProblems = InitionConditionNotProblems_', DataHora, ';']);
            else  % If the Initial Condition variable has been already created before on the workspace, we append it.
                eval(['InitionConditionNotProblems(   (size(InitionConditionNotProblems,1)+1)   :   (size(InitionConditionNotProblems,1) +  size(InitionConditionNotProblems_', DataHora, ',1))  , : ) = InitionConditionNotProblems_', DataHora, ';']);
            end
        else
            % pause
        end
    end
    clear(['InitionConditionNotProblems_', DataHora]);

    if fid2 ~= -1  % If FOPEN returns -1, it means that the apporpriete file does not exist on the Hard Disk. In all the other cases it exist.
		load([DataHora, '_InitionConditionProblems.mat']);
		eval(['cd ', DATESTR(datenum(TimeStart),30), '_InitialCondiction']);
        save([DataHora, '_InitionConditionProblems.mat'], ['InitionConditionProblems_', DataHora]);
		cd ..
        if eval(['size(InitionConditionProblems_', DataHora, ',1)']) > 1
            if length(who('InitionConditionProblems')) == 0 % If the Initial Condition variable was not created before on the workspace, we create it.
                eval(['InitionConditionProblems = InitionConditionProblems_', DataHora, ';']);
            else  % If the Initial Condition variable has been already created before on the workspace, we append it.
                eval(['InitionConditionProblems(   (size(InitionConditionProblems,1)+1)   :   (size(InitionConditionProblems,1) +  size(InitionConditionProblems_', DataHora, ',1))  , : ) = InitionConditionProblems_', DataHora, ';']);
            end
        else
            % pause
        end
    end
    clear(['InitionConditionProblems_', DataHora]);

    NumberSimulationsLeft = NumberSimulationsLeft - 1;
    % Calculation of End of Simulation Time    
    TimeActual = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]
    TimeElapsed = datenum(TimeActual) - datenum(TimeStart); % Time is numerical form in reference to 01JAN0000
    TimeEnd = datenum(TimeActual) + (TimeElapsed/(NumberSimulationsTotal-NumberSimulationsLeft))*(NumberSimulationsLeft);
    Percentage = 100*(NumberSimulationsTotal-NumberSimulationsLeft)/(NumberSimulationsTotal);
    if Percentage > PercentageProgress
        fprintf(1,'%2.0f%% of InicialCondition is done. Starts: %s. Now: %s. End: %s \n', Percentage, datestr(TimeStart), datestr(now), datestr(TimeEnd))
        PercentageProgress = PercentageProgress + 5;
    end
    
end

% Now that we finished simulating all Initial Condictions, we can save the table of BAD ICs
if length(who('InitionConditionProblems')) > 0
% eval(['InitionConditionProblems_', DATESTR(datenum(TimeStart),30), ' = InitionConditionProblems;']);
filename = (['', DATESTR(datenum(TimeStart),30), '_InitionConditionProblemsTogether.mat']);
eval(['cd ', DATESTR(datenum(TimeStart),30), '_InitialCondiction']);
eval(['save(filename,''InitionConditionProblems'')']);
% eval(['save(filename,''InitionConditionProblems_', DATESTR(datenum(TimeStart),30), '*'')']);
cd ..
end
% Now that we finished simulating all Initial Condictions, we can save the table of GOOD ICs
if length(who('InitionConditionNotProblems')) > 0
% eval(['InitionConditionNotProblems_', DATESTR(datenum(TimeStart),30), ' = InitionConditionNotProblems;']);
filename = (['', DATESTR(datenum(TimeStart),30), '_InitionConditionNotProblemsTogether.mat']);
eval(['cd ', DATESTR(datenum(TimeStart),30), '_InitialCondiction']);
eval(['save(filename,''InitionConditionNotProblems'')']);
% eval(['save(filename,''InitionConditionNotProblems_', DATESTR(datenum(TimeStart),30), '*'')']);
cd ..
end

fprintf('\n')

% Now it plays a sound that indicates the end of the simulation
[SimEnd,FqSp,NBits]=wavread('EndOfSimulation.wav');
soundsc(SimEnd,FqSp)
fprintf('\n')

% Now it saves and prints the End of Simulation Time
EndOfSimulation = datestr(now);
fprintf('The simulations Starts on %s\n', datestr(TimeStart));
fprintf('The simulations Ends on %s\n', datestr(EndOfSimulation));
fprintf('\n')

